#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

typedef long long dugacki;

int uporedi(const void *a, const void *b) {
    dugacki x = *(dugacki*)a;
    dugacki y = *(dugacki*)b;
    if (x < y) return -1;
    if (x > y) return 1;
    return 0;
}

int main() {
    int broj_tacaka;
    scanf("%d", &broj_tacaka);

    dugacki *razlike = malloc(broj_tacaka * sizeof(dugacki));
    dugacki *zbirovi = malloc(broj_tacaka * sizeof(dugacki));

    for (int i = 0; i < broj_tacaka; i++) {
        dugacki x, y;
        scanf("%lld %lld", &x, &y);
        razlike[i] = x - y;
        zbirovi[i] = x + y;
    }

    qsort(razlike, broj_tacaka, sizeof(dugacki), uporedi);
    qsort(zbirovi, broj_tacaka, sizeof(dugacki), uporedi);

    dugacki broj_parova = 0;

    for (int i = 0; i < broj_tacaka; ) {
        int j = i;
        while (j < broj_tacaka && razlike[j] == razlike[i]) {
            j++;
        }
        dugacki koliko = j - i;
        broj_parova += koliko * (koliko - 1) / 2;
        i = j;
    }

    for (int i = 0; i < broj_tacaka; ) {
        int j = i;
        while (j < broj_tacaka && zbirovi[j] == zbirovi[i]) {
            j++;
        }
        dugacki koliko = j - i;
        broj_parova += koliko * (koliko - 1) / 2;
        i = j;
    }

    printf("%lld\n", broj_parova * 2);

    return 0;
}